#include "p_secure_true.h"

namespace NModCookiePolicy {
    TPolicySecureTrue::TPolicySecureTrue(TString name, const TPolicySecureTrueCfg& cfg)
        : TNameMatchPolicyBase(name, cfg, true)
        , DomainsFilter_(cfg.domain_filter())
    {}

    bool TPolicySecureTrue::MatchRequest(const TPolicyArgs& args) const noexcept {
        return args.DomainInfo.IsSecure
            && (!DomainsFilter_
                || DomainsFilter_.Included(args.DomainInfo)
                    && !DomainsFilter_.Excluded(args.DomainInfo));
    }

    TMaybe<ICookiePolicy::TAction> TPolicySecureTrue::ApplyToResponseCookie(
        TResponseCookieView c, const TPolicyArgs& args) const noexcept
    {
        if (!c.Const().Secure) {
            if (!args.DryRun) {
                c.Mutable().Secure = true;
            }
            return TAction{.Reasons={EResponseCookieReason::NotSecure}};
        }
        return Nothing();
    }
}
