#pragma once

#include <balancer/modules/cookie_policy/common/cookie_policy.h>

namespace NModCookiePolicy {
    class TPolicyYandexuidCreate final : public TNameMatchPolicyBase {
    public:
        TPolicyYandexuidCreate(TString name, const TPolicyYandexuidCreateCfg& cfg);

    private:
        THolder<IPolicyCustomCtx> NewCtx() const noexcept override;

        bool MatchRequest(const TPolicyArgs&) const noexcept override;

        TRequestCookieActions ApplyToRequestCookies(TVector<TRequestCookie>&, const TPolicyArgs& args) const noexcept override;

        TMaybe<TAction> ApplyToResponseCookie(TResponseCookieView c, const TPolicyArgs& args) const noexcept override;

        void AddSetCookies(TSetCookiesCallback, const TPolicyArgs&) const noexcept override;
    };
}
