#pragma once

#include <balancer/modules/cookie_policy/common/cookie_policy.h>

#include <util/generic/hash_set.h>

namespace NModCookiePolicy {
    class TPolicyYandexuidValue final : public TNameMatchPolicyBase {
    public:
        TPolicyYandexuidValue(TString name, const TPolicyYandexuidValueCfg& cfg);

        THolder<IPolicyCustomCtx> NewCtx() const noexcept override;

    private:
        TRequestCookieActions ApplyToRequestCookies(TVector<TRequestCookie>&, const TPolicyArgs& args) const noexcept override;

        TMaybe<TAction> ApplyToResponseCookie(TResponseCookieView c, const TPolicyArgs& args) const noexcept override;

    private:
        const TPolicyYandexuidValueCfg Cfg_;
        const TFsm ValueRe_;
        // May differ from value_re, it is ok to change an old value if it does not match.
        const TFsm OldValueRe_;
        // It is ok to change these old values.
        THashSet<TString> IgnoredOldValues_;
    };
}
