#include "policy_traits.h"

namespace NModCookiePolicy {
    TCombinedPolicy InitCombinedPolicy(const TModuleConfig& cfg) {
        TCombinedPolicy policy;
        policy.Config = cfg;
        THashSet<TString> uniqNames;
        AppendPolicies<TPolicyGdprClientCookieCfg>(policy.Policies, uniqNames, policy.Config);
        AppendPolicies<TPolicyGdprLifetimeCfg>(policy.Policies, uniqNames, policy.Config);
        AppendPolicies<TPolicyGdprServerCookieCfg>(policy.Policies, uniqNames, policy.Config);
        AppendPolicies<TPolicyIsGdprCookieCfg>(policy.Policies, uniqNames, policy.Config);
        AppendPolicies<TPolicyIsGdprBCookieCfg>(policy.Policies, uniqNames, policy.Config);
        AppendPolicies<TPolicyProtectedCookieCfg>(policy.Policies, uniqNames, policy.Config);
        AppendPolicies<TPolicyYandexuidValueCfg>(policy.Policies, uniqNames, policy.Config);
        AppendPolicies<TPolicyYandexuidCreateCfg>(policy.Policies, uniqNames, policy.Config);
        AppendPolicies<TPolicyPersistentLifetimeCfg>(policy.Policies, uniqNames, policy.Config);
        AppendPolicies<TPolicyGlobalScopeCfg>(policy.Policies, uniqNames, policy.Config);
        AppendPolicies<TPolicyHttpOnlyFalseCfg>(policy.Policies, uniqNames, policy.Config);
        AppendPolicies<TPolicySecureTrueCfg>(policy.Policies, uniqNames, policy.Config);
        AppendPolicies<TPolicySameSiteNoneCfg>(policy.Policies, uniqNames, policy.Config);
        policy.ModeControls = TModeControls(policy.Config.mode_controls());
        policy.GdprControls = TGdprControls(policy.Config.gdpr_controls());
        policy.ParserUuid = cfg.uuid() + "-parser";
        return policy;
    }
}
