#include <balancer/modules/cookie_policy/ut_common/ut_common.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NModCookiePolicy;

Y_UNIT_TEST_SUITE(TPolicyHttpOnlyFalseTest) {
    namespace {
        auto MakeConfig(bool fix) {
            return MakeCombinedPolicy(Sprintf(R"=(instance={
                uuid="xxx";
                http_only_false={
                    yyy={
                        name_re="yandexuid";
                        %s
                    };
                };
            })=", (fix ? "mode='fix'" : "")));
        }
    }

    Y_UNIT_TEST(TestPolicy) {
        Y_COOKIE_POLICY_TEST_POLICY((TPolicyTestCase{
            .In={
                .Cfg=MakeConfig(true),
                .SetCookie=ToCookie({
                    {.Name="yandexuid", .HttpOnly=true},
                    {.Name="other", .HttpOnly=true},
                }),
            },
            .Out={
                .SetCookie=ToCookie({
                    {.Name="yandexuid"},
                    {.Name="other", .HttpOnly=true},
                }),
                .RespLog=" [cpol u:xxx-yyy fail+fix yandexuid=Fix:1!HttpOnly,]",
                .Stats=FixStatsNoGdpr({
                    {"cpol-xxx-modified-resp_summ", 1},
                    {"cpol-xxx-yyy-cookie-fail_summ", 1},
                    {"cpol-xxx-yyy-cookie-fix_summ", 1},
                    {"cpol-xxx-yyy-cookie-skip_summ", 1},
                    {"cpol-xxx-yyy-cookie-total_summ", 2},
                    {"cpol-xxx-yyy-fail_summ", 1},
                    {"cpol-xxx-yyy-fix_summ", 1},
                    {"cpol-xxx-yyy-total_summ", 1},
                }, 2),
            },
        }));
    }

    Y_UNIT_TEST(TestPolicyDryRun) {
        Y_COOKIE_POLICY_TEST_POLICY((TPolicyTestCase{
            .In={
                .Cfg=MakeConfig(false),
                .SetCookie=ToCookie({
                    {.Name="yandexuid", .HttpOnly=true},
                    {.Name="other", .HttpOnly=true},
                }),
            },
            .Out={
                .SetCookie=ToCookie({
                    {.Name="yandexuid", .HttpOnly=true},
                    {.Name="other", .HttpOnly=true},
                }),
                .RespLog=" [cpol u:xxx-yyy fail+dryRun yandexuid=Fix:1!HttpOnly,]",
                .Stats=FixStatsNoGdpr({
                    {"cpol-xxx-yyy-cookie-fail_summ", 1},
                    {"cpol-xxx-yyy-cookie-fix-dryRun_summ", 1},
                    {"cpol-xxx-yyy-cookie-skip_summ", 1},
                    {"cpol-xxx-yyy-cookie-total_summ", 2},
                    {"cpol-xxx-yyy-fail_summ", 1},
                    {"cpol-xxx-yyy-fix-dryRun_summ", 1},
                    {"cpol-xxx-yyy-total_summ", 1},
                }, 2),
            },
        }));
    }
}
