LIBRARY()

OWNER(g:balancer)

SRCS(
    default_yandex_policies.cpp
    p_gdpr_client_cookie.cpp
    p_gdpr_lifetime.cpp
    p_gdpr_server_cookie.cpp
    p_global_scope.cpp
    p_http_only_false.cpp
    p_is_gdpr_cookie.cpp
    p_persistent_lifetime.cpp
    p_protected_cookie.cpp
    p_samesite_none.cpp
    p_secure_true.cpp
    p_yandexuid_create.cpp
    p_yandexuid_value.cpp
    policy_traits.cpp
)

PEERDIR(
    balancer/kernel/client_hints/impl
    balancer/kernel/cookie
    balancer/kernel/cookie/deletion
    balancer/kernel/cookie/domain
    balancer/kernel/cookie/gdpr
    balancer/kernel/http
    balancer/kernel/http/parser
    balancer/kernel/http/string_storage
    balancer/kernel/module
    balancer/kernel/regexp
    balancer/modules/cookie_policy/common
    library/cpp/iterator
    library/cpp/resource
)

# The legacy yandexuid blacklist, has not been updated since 2018-12-07
# svn+ssh://svn.yandex.ru/fuid-keys/trunk/yandex_cookie_eraser.txt
# Legacy perl frontends still use it. We also have to, to avoid false positives for the yandexuid_val policy.
RESOURCE(
    yandex_cookie_eraser.txt /yandex_cookie_eraser.txt
)

END()

RECURSE_FOR_TESTS(
    fuzz
    ut
)
