#include <balancer/modules/cookie_policy/ut_common/utils.h>

#include <library/cpp/testing/unittest/registar.h>


using namespace NModCookiePolicy;


Y_UNIT_TEST_SUITE(TCookiePolicyTestUtilsTest) {
    Y_UNIT_TEST(TestCutUi8) {
        TStringBuf buf("\x22\x23\x24");
        UNIT_ASSERT_VALUES_EQUAL(CutUi8(buf), 0x22);
        UNIT_ASSERT_VALUES_EQUAL(buf, "\x23\x24");
        UNIT_ASSERT_VALUES_EQUAL(CutUi8(buf), 0x23);
        UNIT_ASSERT_VALUES_EQUAL(buf, "\x24");
        UNIT_ASSERT_VALUES_EQUAL(CutUi8(buf), 0x24);
        UNIT_ASSERT_VALUES_EQUAL(buf, "");
        UNIT_ASSERT_VALUES_EQUAL(CutUi8(buf), 0);
        UNIT_ASSERT_VALUES_EQUAL(buf, "");
    }

    Y_UNIT_TEST(TestCutStr) {
        TStringBuf buf("\003abcd");
        UNIT_ASSERT_VALUES_EQUAL(CutStr(buf, "xxx"), "abc");
        UNIT_ASSERT_VALUES_EQUAL(buf, "d");
        UNIT_ASSERT_VALUES_EQUAL(CutStr(buf, "xxx"), "d");
        UNIT_ASSERT_VALUES_EQUAL(buf, "");
        UNIT_ASSERT_VALUES_EQUAL(CutStr(buf, "xxx"), "xxx");
    }

    Y_UNIT_TEST(TestCutStrVec) {
        TStringBuf buf("\003\001a\001b\001c\003\001d");
        UNIT_ASSERT_VALUES_EQUAL(CutStrVec(buf, {"z"}), (TStrVec{"a", "b", "c"}));
        UNIT_ASSERT_VALUES_EQUAL(buf, "\003\001d");
        UNIT_ASSERT_VALUES_EQUAL(CutStrVec(buf, {"z"}), (TStrVec{"d"}));
        UNIT_ASSERT_VALUES_EQUAL(buf, "");
        UNIT_ASSERT_VALUES_EQUAL(CutStrVec(buf, {"z"}), (TStrVec{"z"}));
    }
}
