#pragma once

#include <balancer/kernel/testing/stats.h>

#include <util/generic/strbuf.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NModCookiePolicy {
    using namespace NSrvKernel;
    using namespace NSrvKernel::NTesting;

    // So that I can specialize Out with no fear to violate ODR
    template <class TVal>
    struct TCustomVec : public TVector<TVal> {
        using TParent = TVector<TVal>;
        using TVector<TVal>::TVector;

        bool operator ==(const TCustomVec<TVal>& other) const noexcept {
            return (const TParent&)(*this) == (const TParent&)(other);
        }
    };

    using TStrVec = TCustomVec<TString>;
    using TStatsVec = TCustomVec<std::pair<TString, int>>;


    TStatsVec GetUnistat(TStatsFixture& mock, bool skipZeros = true);

    ui8 CutUi8(TStringBuf& wire);

    TString CutStr(TStringBuf& wire, TString deflt = {});

    TStrVec CutStrVec(TStringBuf& wire, TStrVec deflt = {});
}
