#pragma once

#include <balancer/kernel/funcs/funcs.h>
#include <balancer/kernel/regexp/regexp_pire.h>

#include <util/generic/map.h>
#include <util/generic/string.h>
#include <util/generic/variant.h>
#include <util/string/cast.h>


namespace NModCookies {
    using namespace NSrvKernel;

    struct TCreateCookie {
        std::variant<TString, ECommonFunc> Value;

    public:
        TString GenValue(const TConnDescr& descr) const noexcept;
    };


    using TCookiesFuncSet = THashSet<TString>;
    using TCookiesFuncWeakMap = THashMap<TString, ui32>;


    class TCookieHandler {
    public:
        void Delete(TString regexp);

        void Create(TString name, TCreateCookie create, bool weak);

        TString Apply(TString cookie, const TConnDescr& descr) const noexcept;

    private:
        TFsm Delete_{TFsm::False()};

        TCookiesFuncSet CreateFuncs_;
        TVector<std::pair<TString, TCreateCookie>> CreateFuncsOrder_;
        TCookiesFuncWeakMap CreateFuncsWeak_;
        TVector<std::pair<TString, TCreateCookie>> CreateFuncsWeakOrder_;
    };
}
