#include <balancer/kernel/memory/chunks.h>
#include <balancer/kernel/testing/conn_descr.h>
#include <balancer/kernel/testing/process_mock.h>
#include <balancer/modules/cookies/cookie_handler.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NModCookies;
using namespace NSrvKernel::NTesting;

Y_UNIT_TEST_SUITE(TCookieHandlerTest) {
    Y_UNIT_TEST(TestDelete) {
        TCookieHandler handler;
        TProcessMock process;
        TTestConnDescr descr(process);
        handler.Delete("foo|bar");
        UNIT_ASSERT_VALUES_EQUAL(
            handler.Apply("bla=bla;foo=1;bar=1;x=y", descr.ConnDescr()),
            "bla=bla; x=y"
        );
    }

    Y_UNIT_TEST(TestCreate) {
        TCookieHandler handler;
        TProcessMock process;
        TTestConnDescr descr(process);
        handler.Create("foo" , {TString("bar")}, false);
        UNIT_ASSERT_VALUES_EQUAL(
            handler.Apply("bla=bla;foo=baz;x=y", descr.ConnDescr()),
            "bla=bla; x=y; foo=bar"
        );
    }

    Y_UNIT_TEST(TestCreateWeak) {
        TCookieHandler handler;
        TProcessMock process;
        TTestConnDescr descr(process);
        handler.Create("foo" , {TString("bar")}, true);
        UNIT_ASSERT_VALUES_EQUAL(
            handler.Apply("bla=bla;foo=baz;x=y", descr.ConnDescr()),
            "bla=bla; foo=baz; x=y"
        );
        UNIT_ASSERT_VALUES_EQUAL(
            handler.Apply("bla=bla;x=y", descr.ConnDescr()),
            "bla=bla; x=y; foo=bar"
        );
    }

    Y_UNIT_TEST(TestDeleteCreateWeak) {
        TCookieHandler handler;
        TProcessMock process;
        TTestConnDescr descr(process);
        handler.Delete("foo");
        handler.Create("foo" , {TString("bar")}, true);
        UNIT_ASSERT_VALUES_EQUAL(
            handler.Apply("bla=bla;foo=baz;x=y", descr.ConnDescr()),
            "bla=bla; x=y"
        );
    }

    Y_UNIT_TEST(TestCreateWeakDelete) {
        TCookieHandler handler;
        TProcessMock process;
        TTestConnDescr descr(process);
        handler.Create("foo" , {TString("bar")}, true);
        handler.Delete("foo");
        UNIT_ASSERT_VALUES_EQUAL(
            handler.Apply("bla=bla;foo=baz;x=y", descr.ConnDescr()),
            "bla=bla; x=y"
        );
    }

    Y_UNIT_TEST(TestDeleteCreate) {
        TCookieHandler handler;
        TProcessMock process;
        TTestConnDescr descr(process);
        handler.Delete("foo");
        handler.Create("foo" , {TString("bar")}, false);
        UNIT_ASSERT_VALUES_EQUAL(
            handler.Apply("bla=bla;foo=baz;x=y", descr.ConnDescr()),
            "bla=bla; x=y; foo=bar"
        );
    }

    Y_UNIT_TEST(TestCreateDelete) {
        TCookieHandler handler;
        TProcessMock process;
        TTestConnDescr descr(process);
        handler.Create("foo" , {TString("bar")}, false);
        handler.Delete("foo");
        UNIT_ASSERT_VALUES_EQUAL(
            handler.Apply("bla=bla;foo=baz;x=y", descr.ConnDescr()),
            "bla=bla; x=y; foo=bar"
        );
    }
}
