#include "module.h"

#include <balancer/kernel/module/module.h>

using namespace NSrvKernel;
using namespace NModDummy;

MODULE_BASE(dummy, TModuleWithSubModule) {
public:
    TModule(const TModuleParams& mp)
        : TModuleBase(mp)
    {
        Config->ForEach(this);

        if (!Submodule_) {
            ythrow TConfigParseError() << "no module configured";
        }
    }

private:
    START_PARSE {
        Submodule_.Reset(Loader->MustLoad(key, Copy(value->AsSubConfig())).Release());
        return;
    } END_PARSE

    TError DoRun(const TConnDescr& descr) const noexcept override {
        return Submodule_->Run(descr);
    }
};

IModuleHandle* NModDummy::Handle() {
    return TModule::Handle();
}
