#pragma once

#include <balancer/kernel/helpers/errors.h>
#include <balancer/kernel/net/addr.h>

#include <util/digest/city.h>
#include <util/generic/string.h>
#include <util/network/address.h>
#include <util/system/defaults.h>

namespace NModExpStatic {
    using namespace NSrvKernel;

    struct TExpConf;

    struct TExpRate {
        TString ExtraSalt;
        TString ValueStr;

        double Value = 0;
    };


    struct TExpConf {
        TString Salt;

        ui64 SlotsCount = 100;
        // right now it's constant. See more in BALANCER-1726
        ui64 BucketsCount = 100;

        ui64 ExpId = 0;
        ui64 ContId = 0;
    };


    TString GenCombinedSalt(const TExpConf& conf, const TExpRate& rate) noexcept;


    enum class ESlotType {
        None, Exp, Cont
    };


    struct TExp {
        ui64 Id = 0;
        ui64 Bucket = 0;
        ESlotType Type = ESlotType::None;
    };


    TExp CalcExpByIp(
        const TExpConf& conf, const TExpRate& rate, const TString& combinedSalt, const TIpAddr& remoteAddr) noexcept;
}
