#include <balancer/kernel/net/addr.h>
#include <balancer/kernel/helpers/errors.h>
#include <balancer/modules/exp_static/calc/calc.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(NTestExpStatic) {

    Y_UNIT_TEST(TestDigest) {
        using namespace NModExpStatic;

        auto addr = TIpAddr::FromIp("::1").GetOrThrow();

        TExpConf conf;

        conf.SlotsCount = 100;
        conf.BucketsCount = 100;
        conf.Salt = "y7snEBv5";
        conf.ContId = 1000;
        conf.ExpId = 2000;

        auto rate = FromString<TExpRate>("0.01,khvVIpdN");
        auto salt = GenCombinedSalt(conf, rate);
        UNIT_ASSERT_VALUES_EQUAL(rate.Value, 0.01);
        UNIT_ASSERT_VALUES_EQUAL(rate.ExtraSalt, "khvVIpdN");
        UNIT_ASSERT_VALUES_EQUAL(rate.ValueStr, "0.01");
        UNIT_ASSERT_VALUES_EQUAL(salt, "y7snEBv50.01khvVIpdN");

        {
            rate.Value = 0.01;
            auto exp = CalcExpByIp(conf, rate, salt, addr);
            UNIT_ASSERT_VALUES_EQUAL(exp.Type, ESlotType::None);
            UNIT_ASSERT_VALUES_EQUAL(exp.Id, 0);
            UNIT_ASSERT_VALUES_EQUAL(exp.Bucket, 53);
        }

        {
            rate.Value = 0.4;
            auto exp = CalcExpByIp(conf, rate, salt, addr);
            UNIT_ASSERT_VALUES_EQUAL(exp.Type, ESlotType::Cont);
            UNIT_ASSERT_VALUES_EQUAL(exp.Id, conf.ContId);
            UNIT_ASSERT_VALUES_EQUAL(exp.Bucket, 53);
        }

        {
            rate.Value = 0.8;
            auto exp = CalcExpByIp(conf, rate, salt, addr);
            UNIT_ASSERT_VALUES_EQUAL(exp.Type, ESlotType::Exp);
            UNIT_ASSERT_VALUES_EQUAL(exp.Id, conf.ExpId);
            UNIT_ASSERT_VALUES_EQUAL(exp.Bucket, 53);
        }
    }

    Y_UNIT_TEST(TestRateFromString) {
        using namespace NModExpStatic;

        {
            TExpRate rate;
            rate = FromString<TExpRate>(" 0.1 ");
            UNIT_ASSERT_VALUES_EQUAL(rate.Value, 0.1);
            UNIT_ASSERT_VALUES_EQUAL(rate.ValueStr, "0.1");
            UNIT_ASSERT_VALUES_EQUAL(rate.ExtraSalt, TString());
        }

        {
            TExpRate rate;
            rate = FromString<TExpRate>("0.1 , ");
            UNIT_ASSERT_VALUES_EQUAL(rate.Value, 0.1);
            UNIT_ASSERT_VALUES_EQUAL(rate.ValueStr, "0.1");
            UNIT_ASSERT_VALUES_EQUAL(rate.ExtraSalt, TString());
        }

        {
            TExpRate rate;
            rate = FromString<TExpRate>("0.1 , abc ");
            UNIT_ASSERT_VALUES_EQUAL(rate.Value, 0.1);
            UNIT_ASSERT_VALUES_EQUAL(rate.ValueStr, "0.1");
            UNIT_ASSERT_VALUES_EQUAL(rate.ExtraSalt, "abc");
        }
    }
}
