#include "common.h"

#include <balancer/kernel/module/node.h>

#include <balancer/modules/accesslog/module.h>
#include <balancer/modules/active_check_reply/module.h>
#include <balancer/modules/admin/module.h>
#include <balancer/modules/balancer/module.h>
#include <balancer/modules/cookies/module.h>
#include <balancer/modules/cookie_hasher/module.h>
#include <balancer/modules/cutter/module.h>
#include <balancer/modules/debug/module.h>
#include <balancer/modules/errordocument/module.h>
#include <balancer/modules/errorlog/module.h>
#include <balancer/modules/h100/module.h>
#include <balancer/modules/hdrcgi/module.h>
#include <balancer/modules/headers/module.h>
#include <balancer/modules/headers_forwarder/module.h>
#include <balancer/modules/http/module.h>
#include <balancer/modules/http2/module.h>
#include <balancer/modules/ipdisp/module.h>
#include <balancer/modules/log_headers/module.h>
#include <balancer/modules/meta/module.h>
#include <balancer/modules/pinger/module.h>
#include <balancer/modules/prefix_path_router/module.h>
#include <balancer/modules/proxy/module.h>
#include <balancer/modules/regexp/module.h>
#include <balancer/modules/regexp_host/module.h>
#include <balancer/modules/regexp_path/module.h>
#include <balancer/modules/report/module.h>
#include <balancer/modules/response_headers_if/module.h>
#include <balancer/modules/rewrite/module.h>
#include <balancer/modules/shared/module.h>
#include <balancer/modules/smart_pinger/module.h>
#include <balancer/modules/srcrwr/module.h>
#include <balancer/modules/srcrwr_ext/module.h>
#include <balancer/modules/ssl/sni.h>
#include <balancer/modules/static/module.h>
#include <balancer/modules/stats_eater/module.h>
#include <balancer/modules/tcp_rst_on_error/module.h>
#include <balancer/modules/threshold/module.h>


using namespace NSrvKernel;

const INodeFactory<IModule>* NModulesFactory::CommonModules() {
    struct TFactory: public TNodeFactory<IModule> {
        TFactory() {
                AddHandle(NModAccessLog::Handle());
                AddHandle(NModActiveCheckReply::Handle());
                AddHandle(NModAdmin::Handle());
                AddHandle(NModBalancer::Handle());
                AddHandle(NModBalancer::Handle(), "balancer2");
                AddHandle(NModCookies::Handle());
                AddHandle(NModCookieHasher::Handle());
                AddHandle(NModCutter::Handle());
                AddHandle(NModDebug::Handle());
                AddHandle(NModErrorDocument::Handle());
                AddHandle(NModErrorLog::Handle());
                AddHandle(NModH100::Handle());
                AddHandle(NModHdrCgi::Handle());
                AddHandle(NModHeaders::Handle());
                AddHandle(NModHeadersForwarder::Handle());
                AddHandle(NModHttp2::Handle());
                AddHandle(NModHttp::Handle());
                AddHandle(NModIpDispatch::Handle());
                AddHandle(NModLogHeaders::Handle());
                AddHandle(NModMeta::Handle());
                AddHandle(NModPinger::Handle());
                AddHandle(NModPrefixPathRouter::Handle());
                AddHandle(NModProxy::Handle());
                AddHandle(NModRegexp::Handle());
                AddHandle(NModRegexpHost::Handle());
                AddHandle(NModRegexpPath::Handle());
                AddHandle(NModReport::Handle());
                AddHandle(NModResponseHeaders::Handle());
                AddHandle(NModResponseHeadersIf::Handle());
                AddHandle(NModRewrite::Handle());
                AddHandle(NModShared::Handle());
                AddHandle(NModSmartPinger::Handle());
                AddHandle(NModSrcrwr::Handle());
                AddHandle(NModSrcrwrExt::Handle());
                AddHandle(NModSsl::SniHandle());
                AddHandle(NModStatic::Handle());
                AddHandle(NModStatsEater::Handle());
                AddHandle(NModTcpRstOnError::Handle());
                AddHandle(NModThreshold::Handle());
        }
    };

    return &Default<TFactory>();
}
