#include <balancer/modules/flags_getter/utils.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TestFlagsGetter) {
    Y_UNIT_TEST(JoinFlagsPath) {
        using namespace NModFlagsGetter;

        UNIT_ASSERT_VALUES_EQUAL(JoinFlagsPath("a", ""), "a/");
        UNIT_ASSERT_VALUES_EQUAL(JoinFlagsPath("a", "/"), "a/");
        UNIT_ASSERT_VALUES_EQUAL(JoinFlagsPath("a", "?"), "a/");
        UNIT_ASSERT_VALUES_EQUAL(JoinFlagsPath("a", "#"), "a/");
        UNIT_ASSERT_VALUES_EQUAL(JoinFlagsPath("a", "b"), "a/b");
        UNIT_ASSERT_VALUES_EQUAL(JoinFlagsPath("a", "?b"), "a/");
        UNIT_ASSERT_VALUES_EQUAL(JoinFlagsPath("a", "#b"), "a/");
        UNIT_ASSERT_VALUES_EQUAL(JoinFlagsPath("a", "/b"), "a/b");
        UNIT_ASSERT_VALUES_EQUAL(JoinFlagsPath("a", "/b/"), "a/b/");
        UNIT_ASSERT_VALUES_EQUAL(JoinFlagsPath("a", "/b/c"), "a/b/c");
        UNIT_ASSERT_VALUES_EQUAL(JoinFlagsPath("a", "/b?c"), "a/b");
        UNIT_ASSERT_VALUES_EQUAL(JoinFlagsPath("a", "/b#c"), "a/b");
    }
}
