#include "hasher.h"
#include "barnavig.h"
#include "subnet.h"
#include "request.h"
#include "text.h"
#include "random.h"

using namespace NSrvKernel;
using namespace NModHasher;

const INodeFactory<IHasher>* NSrvKernel::CommonHashers() {
    struct TFactory: public TNodeFactory<IHasher> {
        TFactory() {
            AddHandle(NBarnavig::Handle());
            AddHandle(NSubnet::Handle());
            AddHandle(NRequest::Handle());
            AddHandle(NText::Handle());
            AddHandle(NRandom::Handle());
        }
    };

    return &Default<TFactory>();
}
