#pragma once

#include <balancer/kernel/module/node.h>
#include <balancer/kernel/helpers/errors.h>

namespace NSrvKernel {
    class TConnDescr;

    class IHasher {
    public:
        virtual ~IHasher() = default;

        virtual TErrorOr<ui64> CalcHash(const TConnDescr& descr) const noexcept = 0;
    };

    const INodeFactory<IHasher>* CommonHashers();
}

#define HASHER(X) NODEIMPL(IHasher, THasher, X)
