#include "random.h"

#include "hasher.h"

#include <balancer/kernel/module/iface.h>

#include <util/random/random.h>

using namespace NSrvKernel;
using namespace NModHasher;

HASHER(random) {
    THasher(const TModuleParams& mp) {
        Y_UNUSED(mp);
    }

    TErrorOr<ui64> CalcHash(const TConnDescr&) const noexcept override {
        return RandomNumber<ui64>();
    }
};

INodeHandle<IHasher>* NModHasher::NRandom::Handle() {
    return THasher::Handle();
}
