#include "request.h"
#include "hasher.h"

#include <balancer/kernel/http/parser/http.h>
#include <balancer/kernel/memory/split.h>
#include <balancer/kernel/module/iface.h>

using namespace NSrvKernel;
using namespace NModHasher;

HASHER(request) {
    THasher(const TModuleParams&) {
    }

    TErrorOr<ui64> CalcHash(const TConnDescr& descr) const noexcept override {
        const TRequestLine& requestLine = descr.Request->RequestLine();
        TMurmurHash2A<ui64> hash;
        hash.Update(requestLine.Path.AsStringBuf().Data(), requestLine.Path.AsStringBuf().Size());
        hash.Update(requestLine.CGI.AsStringBuf().Data(), requestLine.CGI.AsStringBuf().Size());
        return hash.Value();
    }
};

INodeHandle<IHasher>* NModHasher::NRequest::Handle() {
    return THasher::Handle();
}
