#pragma once

#include <balancer/kernel/http/parser/http.h>

#include <util/generic/ptr.h>
#include <util/generic/string.h>

namespace NHeadersForwarder {
    using namespace NSrvKernel;

    class TSimpleHandler : public TMoveOnly {
        struct TValueToCreate {
            TString Name;
            TString Value;
            bool Weak = false;
        };

    public:
        void Create(const TString& nameLowerCase, const TString& name, const TString& value, bool weak) noexcept {
            HeadersToCreate_[nameLowerCase] = TValueToCreate{name, value, weak};
        }

        void Delete(const TString& nameLowerCase) noexcept {
            HeadersToDelete_.insert(nameLowerCase);
        }

        void ApplyRequest(NSrvKernel::TRequest& request) const noexcept {
            ApplyExt(request.Headers());
        }

        void ApplyResponse(NSrvKernel::TResponse& response) const noexcept {
            ApplyExt(response.Headers());
        }

    private:
        void ApplyExt(THeaders& headers) const noexcept;

    private:
        THashMap<TString, TValueToCreate> HeadersToCreate_;
        THashSet<TString> HeadersToDelete_;
    };

}  // namespace NHeadersForwarder
