#pragma once

#include <balancer/kernel/helpers/errors.h>


namespace NSrvKernel {
    class TRequest;
}

namespace NModHttp {

    class TCyclesChecker final {
    public:
        TCyclesChecker(const TString& configUid, uint64_t maxCycles, uint64_t maxLength);

        NSrvKernel::TError Check(NSrvKernel::TRequest& request, TString& lengthAlert, TString& formatAlert) const noexcept;

    private:
        NSrvKernel::TError SetNewHeader(NSrvKernel::TRequest& request) const noexcept;
        TString MakeUid() const;
        void AddCounter(TString& id, uint64_t counter) const;

    private:
        const TString ConfigUid_;
        const uint64_t MaxCycles_ = 0;
        const uint64_t MaxLength_ = 0;
    };
}

