#include "cookie_masker.h"

#include <algorithm>


namespace NModLogHeaders {

constexpr char MaskSymbol = 'X';

TCookieMasker::TCookieMasker() {
    SecretKeys_.insert("Session_id");
    SecretKeys_.insert("sessionid2");
    SecretKeys_.insert("sessguard");
    SecretKeys_.insert("webauth_oauth_token");
}

bool TCookieMasker::ShouldMask(const TStringBuf& key) const {
    return SecretKeys_.find(key) != SecretKeys_.end();
}

void TCookieMasker::MaskCookieParam(TString& value) const {
    if (value.empty()) {
        Y_ASSERT(false);
        return;
    }
    const auto len = value.length();
    if (auto immutableEnd = value.rfind('.'); immutableEnd != TString::npos && ++immutableEnd < len) {
        std::fill(&value[immutableEnd], &value[len], MaskSymbol);
    } else { // mask whole value
        std::fill(&value[0], &value[len], MaskSymbol);
    }
}

}