#pragma once

#include <balancer/kernel/client_request/backend_config.h>
#include <balancer/kernel/http/parser/status_codes/status_codes.h>

namespace NModProxy {
struct TProxyConfig {
    TString Name;

    NSrvKernel::TBackendConfig BackendConfig;

    NSrvKernel::TStatusCodeReactions StatusCodeReactions;
    TDuration SwitchedBackendTimeout = TDuration::Hours(2);
    TDuration BackendReadTimeout = TDuration::Max();
    TDuration BackendWriteTimeout = TDuration::Max();
    TDuration ClientReadTimeout = TDuration::Max();
    TDuration ClientWriteTimeout = TDuration::Max();
    TMaybe<TDuration> KeepAliveTimeout;

    bool Buffering = false;

    size_t KeepAliveCount = 0;
    bool KeepAliveCheckForUnexpectedData = false;

    bool AllowConnectionUpgrade = false;
    bool AllowConnectionUpgradeWithoutConnectionHeader = false;

    bool WatchClientClose = false;

    bool KeepAllHeaders = false;

    bool UseSameHttpVersion = false;
    bool Http2Backend = false;
};
}
