#include "tls.h"

namespace {
const TVector<ui64> ConnectionAccessIntervals = {
        0,
        5,
        10,
        25,
        50,
        100,
        150,
        200,
        250,
        500,
        750,
        1000,
        2500,
        5000,
        7500,
        10000,
        50000,
        100000,
        1000000
};
}

namespace NModProxy {
    TTls::TTls(NSrvKernel::TSharedStatsManager& statsManager)
            : HttpParseError(statsManager.MakeCounter("proxy-http_response_parse_error").AllowDuplicate().Build()),
              HttpCompleteResponseParseError(statsManager.MakeCounter("proxy-http_complete_response_parse_error").AllowDuplicate().Build()),
              ConnectionAccessTimes(statsManager.MakeHistogram("proxy-connection_time_ms", ConnectionAccessIntervals).AllowDuplicate().Scale(1e3).Build())
    {}
} // namespace NModProxy
