#pragma once

#include <balancer/kernel/stats/manager.h>
#include <balancer/kernel/coro/coroutine.h>
#include <balancer/kernel/connection_manager_helpers/helpers.h>
#include <balancer/kernel/coro/coro_cond_var.h>
#include <balancer/kernel/client_request/backend.h>
#include <balancer/kernel/connection_manager/connection_pool.h>

namespace NModProxy {
class TTls {
public:
    virtual ~TTls() = default;

    TTls(NSrvKernel::TSharedStatsManager& statsManager);

    virtual THolder<TKeepAliveData> GetKeepAliveConnection(const TConnDescr& descr, const THostInfo& hostInfo) noexcept = 0;
    virtual bool CanStoreKeepaliveConnection(const TConnDescr& descr, const THostInfo& hostInfo) const noexcept = 0;
    virtual void StoreKeepaliveConnection(THolder<TKeepAliveData> keepAlive) noexcept = 0;

    NSrvKernel::TSharedCounter HttpParseError;
    NSrvKernel::TSharedCounter HttpCompleteResponseParseError;
    NSrvKernel::TSharedHistogram ConnectionAccessTimes;
    NSrvKernel::TBackendProtocols State;
};
} // namespace NProxy
