#pragma once

#include <balancer/modules/redirects/redirects.cfgproto.pb.h>

#include <util/generic/maybe.h>
#include <util/generic/strbuf.h>

namespace NModRedirects::NImpl {

    struct TUrl {
        TStringBuf Scheme;
        TStringBuf Host;
        TStringBuf Path;
        TStringBuf Query;
        TStringBuf Fragment;

        auto AsTuple() const noexcept {
            return std::make_tuple(Scheme, Host, Path, Query, Fragment);
        }

        bool operator== (const TUrl& other) const noexcept {
            return AsTuple() == other.AsTuple();
        }
    };

    TUrl SplitUrl(TStringBuf src) noexcept;

    TString MergeUrl(TUrl src) noexcept;

    TUrl ReplaceUrlParts(TUrl from, TUrl with, TUrlParts what) noexcept;
}
