#include <balancer/modules/redirects/url_parts.h>

#include <library/cpp/iterator/functools.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NModRedirects;
using namespace NModRedirects::NImpl;

Y_UNIT_TEST_SUITE(TUrlPartsTest) {
    void DoTestSplitMerge(TStringBuf url, TUrl expected) {
        auto res = SplitUrl(url);
        UNIT_ASSERT_VALUES_EQUAL(res, expected);
        UNIT_ASSERT_VALUES_EQUAL(MergeUrl(res), url);
    }

    Y_UNIT_TEST(TestSplitMerge) {
        DoTestSplitMerge("a/b?c&d#e/f?g&h", TUrl{
            .Path="a/b",
            .Query="c&d",
            .Fragment="e/f?g&h",
        });
        DoTestSplitMerge("//a/b?c&d#e/f?g&h", TUrl{
            .Scheme="//",
            .Host="a",
            .Path="/b",
            .Query="c&d",
            .Fragment="e/f?g&h",
        });
        DoTestSplitMerge("ws://a/b?c&d#e/f?g&h", TUrl{
            .Scheme="ws://",
            .Host="a",
            .Path="/b",
            .Query="c&d",
            .Fragment="e/f?g&h",
        });
        DoTestSplitMerge("?c&d#e/f?g&h", TUrl{
            .Query="c&d",
            .Fragment="e/f?g&h",
        });
        DoTestSplitMerge("ws://?c&d#e/f?g&h", TUrl{
            .Scheme="ws://",
            .Query="c&d",
            .Fragment="e/f?g&h",
        });
        DoTestSplitMerge("ws:///?c&d#e/f?g&h", TUrl{
            .Scheme="ws://",
            .Path="/",
            .Query="c&d",
            .Fragment="e/f?g&h",
        });
        DoTestSplitMerge("ws:///?c&d#e/f?g&h", TUrl{
            .Scheme="ws://",
            .Path="/",
            .Query="c&d",
            .Fragment="e/f?g&h",
        });
        DoTestSplitMerge("ws:///b?c&d#e/f?g&h", TUrl{
            .Scheme="ws://",
            .Path="/b",
            .Query="c&d",
            .Fragment="e/f?g&h",
        });
    }
}
