#pragma once

#include <util/generic/strbuf.h>
#include <util/generic/string.h>
#include <util/generic/yexception.h>

#include <library/cpp/regex/pire/regexp.h>


namespace NReport {
    template <class T>
    static inline const T& CheckedUuid(const T& uuid) {
        struct TUuidFsm: public TStringBuf, private NRegExp::TFsm {
            TUuidFsm()
                : TStringBuf("[-a-z0-9_]+")
                , TFsm(static_cast<const TStringBuf&>(*this))
            {}

            bool Match(const T& uuid) const {
                return NRegExp::TMatcher(*this).Match(uuid).Final();
            }
        } const& fsm = Default<TUuidFsm>();

        if (!fsm.Match(uuid)) {
            throw yexception() << "unvalid uuid \"" << uuid << "\": not matched /" << TStringBuf(fsm) << '/';
        }

        return uuid;
    }
}
