#include "record.h"

namespace NReport {

    TRecord::TRecord(
        TRecordRanges ranges,
        const TCodesSet& codesSet,
        TString uuid,
        const NMonitoring::TLabels& labels,
        TSharedStatsManager& statsManager,
        const THashSet<TString>& disabledSignals
    )
        : Data_(MakeIntrusive<TRecordData>(
            std::move(ranges),
            codesSet,
            std::move(uuid),
            labels,
            statsManager,
            disabledSignals
        ))
    {}

    TRecord::TRecord(const TRecord& other, size_t workerId)
        : IsUnique_(other.IsUnique_)
        , Data_(MakeIntrusive<TRecordData>(*other.Data_, workerId))
        , Matchers_(other.Matchers_)
    {
        MatcherData_.reserve(other.MatcherData_.size());
        for (const auto& counter : other.MatcherData_) {
            MatcherData_.emplace_back(MakeIntrusive<TRecordData>(*counter, workerId));
        }
    }
}

