#pragma once

#include "record_data.h"

#include <balancer/kernel/helpers/ranges.h>
#include <balancer/kernel/matcher/matcher.h>

#include <library/cpp/monlib/metrics/labels.h>

#include <util/generic/intrlist.h>
#include <util/generic/maybe.h>
#include <util/generic/ptr.h>
#include <util/generic/vector.h>

namespace NReport {

    class TRecord : TMoveOnly {
    public:
        TRecord(
            TRecordRanges ranges,
            const TCodesSet& codesSet,
            TString uuid,
            const NMonitoring::TLabels& labels,
            TSharedStatsManager& statsManager,
            const THashSet<TString>& disabledSignals
        );

        TRecord(const TRecord& other, size_t workerId);

        const TString& Uuid() const noexcept {
            return Data_->Uuid();
        }

    public:
        TRecordData& Data() noexcept {
            return *Data_;
        }

        bool UpdateRanges(const TRecordRanges& other) noexcept {
            return Data_->UpdateRanges(other);
        }

        bool IsUnique() const {
            return IsUnique_;
        }

        void MarkDuplicate() {
            IsUnique_ = false;
        }

        TVector<TAtomicSharedPtr<NSrvKernel::IRequestMatcher>>& Matchers() {
            return Matchers_;
        }

        const TVector<TAtomicSharedPtr<NSrvKernel::IRequestMatcher>>& Matchers() const {
            return Matchers_;
        }

        TVector<TRecordDataPtr>& MatcherData() {
            return MatcherData_;
        }

        const TVector<TRecordDataPtr>& MatcherData() const {
            return MatcherData_;
        }

        void DisableSslness(bool value) {
            Data_->DisableSslness(value);
        }

        void DisableRobotness(bool value) {
            Data_->DisableRobotness(value);
        }

    private:
        bool IsUnique_ = true;
        TRecordDataPtr Data_;
        TVector<TAtomicSharedPtr<NSrvKernel::IRequestMatcher>> Matchers_;
        TVector<TRecordDataPtr> MatcherData_;
    };
}

