#include <library/cpp/testing/unittest/registar.h>

#include <balancer/modules/report/legacy_range.h>


Y_UNIT_TEST_SUITE(TReportLegacyRangeTest) {
    Y_UNIT_TEST(TestStatus) {
        using namespace NReport;
        using namespace NLegacyRange;

        const auto filter = TDimFilter().Set(EDim::Status);

        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetStatus(404)), 6);

        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetStatus(0)), 0);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetStatus(99)), 0);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetStatus(100)), 1);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetStatus(199)), 1);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetStatus(200)), 2);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetStatus(299)), 2);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetStatus(300)), 3);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetStatus(399)), 3);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetStatus(400)), 4);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetStatus(499)), 4);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetStatus(500)), 5);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetStatus(599)), 5);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetStatus(600)), 0);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetStatus(700)), 0);

        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 0), "<x sc=\"err\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 1), "<x sc=\"1xx\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 2), "<x sc=\"2xx\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 3), "<x sc=\"3xx\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 4), "<x sc=\"4xx\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 5), "<x sc=\"5xx\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 6), "<x sc=\"404\">");
    }

    Y_UNIT_TEST(TestRobot) {
        using namespace NReport;
        using namespace NLegacyRange;

        const auto filter = TDimFilter().Set(EDim::Robot);

        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetRobot(Nothing())), 0);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetRobot(false)), 1);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetRobot(true)), 2);

        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 0), "<x sr=\"u\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 1), "<x sr=\"n\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 2), "<x sr=\"y\">");
    }

    Y_UNIT_TEST(TestInternal) {
        using namespace NReport;
        using namespace NLegacyRange;

        const auto filter = TDimFilter().Set(EDim::Internal);

        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetInternal(Nothing())), 0);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetInternal(false)), 1);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetInternal(true)), 2);

        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 0), "<x ir=\"u\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 1), "<x ir=\"n\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 2), "<x ir=\"y\">");
    }

    Y_UNIT_TEST(TestSsl) {
        using namespace NReport;
        using namespace NLegacyRange;

        const auto filter = TDimFilter().Set(EDim::Ssl);

        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetSsl({false, false})), 0);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetSsl({true, false})), 1);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetSsl({false, true})), 2);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(filter, TDimData().SetSsl({true, true})), 3);

        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 0), "<x sl=\"cu\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 1), "<x sl=\"cU\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 2), "<x sl=\"Cu\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(filter, 3), "<x sl=\"CU\">");

    }

    Y_UNIT_TEST(TestMatrixSize) {
        using namespace NReport;
        using namespace NLegacyRange;

        UNIT_ASSERT_EQUAL(GetMatrixSize({}), 1);
        UNIT_ASSERT_EQUAL(GetMatrixSize(TDimFilter().SetAll()), 7 * 3 * 3 * 4);
        UNIT_ASSERT_EQUAL(GetMatrixSize(
            TDimFilter().Set(EDim::Status).Set(EDim::Robot).Set(EDim::Internal).Set(EDim::Ssl)), 7 * 3 * 3 * 4);

        UNIT_ASSERT_EQUAL(GetMatrixSize(TDimFilter().Set(EDim::Status)), 7);
        UNIT_ASSERT_EQUAL(GetMatrixSize(TDimFilter().SetAll().Reset(EDim::Status)), 3 * 3 * 4);

        UNIT_ASSERT_EQUAL(GetMatrixSize(TDimFilter().Set(EDim::Robot)), 3);
        UNIT_ASSERT_EQUAL(GetMatrixSize(TDimFilter().SetAll().Reset(EDim::Robot)), 7 * 3 * 4);

        UNIT_ASSERT_EQUAL(GetMatrixSize(TDimFilter().Set(EDim::Internal)), 3);
        UNIT_ASSERT_EQUAL(GetMatrixSize(TDimFilter().SetAll().Reset(EDim::Internal)), 7 * 3 * 4);

        UNIT_ASSERT_EQUAL(GetMatrixSize(TDimFilter().Set(EDim::Ssl)), 4);
        UNIT_ASSERT_EQUAL(GetMatrixSize(TDimFilter().SetAll().Reset(EDim::Ssl)), 7 * 3 * 3);

        UNIT_ASSERT_EQUAL(GetMatrixSize(TDimFilter().Set(EDim::Status).Set(EDim::Internal)), 7 * 3);
        UNIT_ASSERT_EQUAL(GetMatrixSize(TDimFilter().Set(EDim::Robot).Set(EDim::Ssl)), 3 * 4);
        UNIT_ASSERT_EQUAL(GetMatrixSize(TDimFilter().SetAll().Reset(EDim::Status)), 3 * 3 * 4);
        UNIT_ASSERT_EQUAL(GetMatrixSize(TDimFilter().SetAll().Reset(EDim::Status).Reset(EDim::Ssl)), 3 * 3);
    }

    Y_UNIT_TEST(TestIndex) {
        using namespace NReport;
        using namespace NLegacyRange;

        UNIT_ASSERT_VALUES_EQUAL(GetIndex({}, TDimData().SetStatus(404)), 0);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex({}, TDimData().SetRobot(true)), 0);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex({}, TDimData().SetInternal(true)), 0);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex({}, TDimData().SetSsl({true, true})), 0);

        UNIT_ASSERT_VALUES_EQUAL(GetIndex(TDimFilter().Set(EDim::Status), TDimData().SetStatus(404)), 6);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(TDimFilter().Set(EDim::Robot), TDimData().SetRobot(true)), 2);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(TDimFilter().Set(EDim::Internal), TDimData().SetInternal(true)), 2);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(TDimFilter().Set(EDim::Ssl), TDimData().SetSsl({true, true})), 3);

        const auto allFilter = TDimFilter().Set(EDim::Status).Set(EDim::Robot).Set(EDim::Internal).Set(EDim::Ssl);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(allFilter, TDimData()), 0);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(allFilter, TDimData().SetStatus(404)), 6);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(allFilter, TDimData().SetRobot(true)), 2 * 7);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(allFilter, TDimData().SetInternal(true)), 2 * 3 * 7);
        UNIT_ASSERT_VALUES_EQUAL(GetIndex(allFilter, TDimData().SetSsl({true, true})), 3 * 3 * 3 * 7);
    }

    Y_UNIT_TEST(TestPrefix) {
        using namespace NReport;
        using namespace NLegacyRange;

        UNIT_ASSERT_VALUES_EQUAL(GetSuffix(), "</x>");

        UNIT_ASSERT_VALUES_EQUAL(GetPrefix({}, 0), "<x>");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(TDimFilter().Set(EDim::Status), 0), "<x sc=\"err\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(TDimFilter().Set(EDim::Robot), 0), "<x sr=\"u\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(TDimFilter().Set(EDim::Internal), 0), "<x ir=\"u\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(TDimFilter().Set(EDim::Ssl), 0), "<x sl=\"cu\">");
        UNIT_ASSERT_VALUES_EQUAL(GetPrefix(TDimFilter().SetAll(), 0), "<x sc=\"err\" sr=\"u\" ir=\"u\" sl=\"cu\">");

        UNIT_ASSERT_VALUES_EQUAL(
            GetPrefix(TDimFilter().Set(EDim::Status).Set(EDim::Internal), 0), "<x sc=\"err\" ir=\"u\">");
        UNIT_ASSERT_VALUES_EQUAL(
            GetPrefix(TDimFilter().Set(EDim::Robot).Set(EDim::Ssl), 0), "<x sr=\"u\" sl=\"cu\">");

        {
            const auto filter = TDimFilter().Set(EDim::Status).Set(EDim::Internal);
            UNIT_ASSERT_VALUES_EQUAL(
                GetPrefix(filter, GetIndex(filter, TDimData().SetStatus(404).SetInternal(true))),
                "<x sc=\"404\" ir=\"y\">");
        }
        {
            const auto filter = TDimFilter().Set(EDim::Robot).Set(EDim::Ssl);
            UNIT_ASSERT_VALUES_EQUAL(
                GetPrefix(filter, GetIndex(filter, TDimData().SetRobot(true).SetSsl({true, true}))),
                "<x sr=\"y\" sl=\"CU\">");
        }
    }
}
