#pragma once

#include <util/generic/string.h>


namespace NSrvKernel::NSrcrwr {
struct TAddr;
class TAddrs;
}

namespace NModSrcrwrExt {

class THandler {
public:
    TString& PrefixToRemove() { return PrefixToRemove_; }
    TString& Domains() { return Domains_; }

    bool Handle(const TString& host, NSrvKernel::NSrcrwr::TAddrs*& addrs) const;
    void CleanUp(NSrvKernel::NSrcrwr::TAddrs*& addrs) const;

private:
    bool Parse(const TString& host, TVector<NSrvKernel::NSrcrwr::TAddr>& addrs) const noexcept;

private:
    TString PrefixToRemove_;
    TString Domains_;
};

}