#pragma once

#include <library/cpp/config/sax.h>
#include <openssl/ssl.h>
#include <util/generic/ptr.h>
#include <util/generic/string.h>

namespace NModSsl {
    // See defaults in cpp file
    struct TClientSettings {
        int VerifyMode;
        int VerifyDepth;
        TString Crl;

    private:
        TClientSettings(int mode, int depth, TString crl) noexcept
            : VerifyMode(mode)
            , VerifyDepth(depth)
            , Crl(std::move(crl))
        {}
        friend THolder<TClientSettings> ParseSettings(NConfig::IConfig* conf);
    };

    THolder<TClientSettings> ParseSettings(NConfig::IConfig* conf);
}
