#include "matcher.h"

THolder<NModSsl::IServernameMatcher> NModSsl::ConstructMatcher(NConfig::IConfig* config) {
    struct TConfigParser final : public NConfig::IConfig::IFunc {
        TConfigParser(NConfig::IConfig * config) {
            config->ForEach(this);
        }
        START_PARSE {
            ON_KEY("servername_regexp", Regexp) {
                return;
            }

            ON_KEY("case_insensitive", CaseInsensitive) {
                return;
            }

            ON_KEY("surround", Surround) {
                return;
            }

        } END_PARSE

        bool CaseInsensitive = true;
        bool Surround = false;
        TString Regexp;
    } parser(config);
    if (!parser.Regexp) {
        ythrow NConfig::TConfigParseError() << "no servername configured for ssl_sni";
    }
    return MakeHolder<TFsmServernameMatcher>(std::move(parser.Regexp),
            NSrvKernel::TFsm::TOptions()
            .SetSurround(parser.Surround)
            .SetCaseInsensitive(parser.CaseInsensitive)
        );
}
