#pragma once

#include <balancer/kernel/regexp/regexp_pire.h>

#include <library/cpp/config/sax.h>
#include <library/cpp/regex/pire/pire.h>

#include <util/generic/strbuf.h>

namespace NModSsl {
    class IServernameMatcher {
    public:
        virtual bool Match(TStringBuf servername) const noexcept = 0;
        virtual ~IServernameMatcher() = default;
    };

    class TAllServersMatcher final : public IServernameMatcher {
    public:
        bool Match(TStringBuf servername) const noexcept override {
            Y_UNUSED(servername);
            return true;
        }
    };

    class TFsmServernameMatcher final : public IServernameMatcher {
    public:
        TFsmServernameMatcher(TString regexp, NSrvKernel::TFsm::TOptions options)
            : Fsm_(std::move(regexp), options)
        {}

        bool Match(TStringBuf servername) const noexcept override {
            NSrvKernel::TMatcher m(Fsm_);
            return m.Match(servername).Final();
        }

    private:
        NSrvKernel::TFsm Fsm_;
    };

    THolder<IServernameMatcher> ConstructMatcher(NConfig::IConfig* config);
}

