#include <balancer/modules/ssl/matcher.h>

#include <balancer/kernel/module/conn_descr.h>
#include <balancer/kernel/testing/conn_descr.h>
#include <balancer/kernel/custom_io/chunkio.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/json/json_reader.h>


using namespace NSrvKernel;
using namespace NModSsl;
using namespace NSrvKernel::NTesting;

Y_UNIT_TEST_SUITE(TMatcherTests) {
    template <bool match>
    void CheckFsmMatch(TString pattern, TString regexp, TFsm::TOptions opt = {}) {
        TFsmServernameMatcher m(std::move(regexp), opt);
        UNIT_ASSERT_EQUAL(m.Match(pattern), match);
    }
    template <bool match>
    void CheckCaseInsensitive(TString pattern, TString regexp) {
        return CheckFsmMatch<match>(std::move(pattern), std::move(regexp), TFsm::TOptions().SetCaseInsensitive(true));
    }
    template <bool match>
    void CheckSurround(TString pattern, TString regexp) {
        return CheckFsmMatch<match>(std::move(pattern), std::move(regexp), TFsm::TOptions().SetSurround(true));
    }

    Y_UNIT_TEST(FsmServernameMatcher) {
        CheckFsmMatch<true>("abc", "abc");
        CheckFsmMatch<false>("Abc", "abc");
        CheckFsmMatch<false>("abcdef", "abc");

        CheckCaseInsensitive<true>("abc", "abc");
        CheckCaseInsensitive<true>("Abc", "abc");
        CheckCaseInsensitive<false>("abcdef", "abc");

        CheckSurround<true>("abc", "abc");
        CheckSurround<false>("Abc", "abc");
        CheckSurround<true>("abcdef", "abc");

        CheckCaseInsensitive<true>(
            "xn--d1acpjx3f.xn--p1ai", "((m|www)[.])?yandex[.](az|co[.]il|ee|kg|lt|lv|md|tj|tm)|(.*[.])?xn--d1acpjx3f[.]xn--p1ai");
    }
}
