#include "module.h"

#include <balancer/kernel/custom_io/chunkio.h>
#include <balancer/kernel/helpers/errors.h>
#include <balancer/kernel/http/parser/httpencoder.h>
#include <balancer/kernel/http/parser/http.h>
#include <balancer/kernel/memory/chunks.h>
#include <balancer/kernel/module/module.h>
#include <balancer/kernel/custom_io/stream.h>

#include <library/cpp/http/misc/httpcodes.h>
#include <library/cpp/string_utils/base64/base64.h>

#include <util/stream/file.h>

using namespace NConfig;
using namespace NSrvKernel;
using namespace NModStatsEater;

MODULE(stats_eater) {
public:
    TModule(const TModuleParams& mp)
        : TModuleBase(mp)
    {
        Config->ForEach(this);

        if (!Submodule_) {
            ythrow TConfigParseError() << "no submodule configured";
        }
    }

private:
    START_PARSE {
        Submodule_.Reset(Loader->MustLoad(key, Copy(value->AsSubConfig())).Release());
        return;
    } END_PARSE

    TError DoRun(const TConnDescr& descr) const noexcept override {
        return Submodule_->Run(descr);
    }

private:
    THolder<IModule> Submodule_;
};

IModuleHandle* NModStatsEater::Handle() {
    return TModule::Handle();
}
