#include "module.h"

#include <balancer/kernel/module/module.h>
#include <balancer/kernel/net/socket.h>
#include <balancer/kernel/custom_io/stream.h>

using namespace NSrvKernel;
using namespace NModTcpRstOnError;

MODULE_BASE(tcp_rst_on_error, TModuleWithSubModule) {
public:
    TModule(const TModuleParams& mp)
        : TModuleBase(mp)
    {
        Config->ForEach(this);

        if (!Submodule_) {
            ythrow TConfigParseError() << "no module configured";
        }
    }

private:
    START_PARSE {
        ON_KEY("send_rst", SendRst_) {
            return;
        }

        Submodule_.Reset(Loader->MustLoad(key, Copy(value->AsSubConfig())).Release());
        return;
    } END_PARSE

    TError DoRun(const TConnDescr& descr) const noexcept override {
        descr.Properties->Parent.TcpRstOnError = SendRst_;
        return Submodule_->Run(descr);
    }

private:
    bool SendRst_{ true };
};

IModuleHandle* NModTcpRstOnError::Handle() {
    return TModule::Handle();
}
