from balancer.production.l7_alerts.solomon.registry.channel.channels import multialert_juggler_channel
from library.python.monitoring.solo.objects.juggler import Check, Child, NotificationOptions


class Tags:
    # L7
    L7_AlERT_FOR_L3_RS_DOWN = "l3_rs_down_alert"

    # WARDEN
    WARDEN_AUTO_SOURCE = "warden_auto_source"
    WARDEN_ALERT_CREATE_SPI = "warden_alert_create_spi"
    WARDEN_ALERT_ACCOUNT_METRIC = "warden_alert_account_metric"
    WARDEN_ALERT_ACCOUNT_BACKGROUND_METRIC = "warden_alert_account_background_metric"
    WARDEN_ALERT_START_FLOW = "warden_alert_start_flow"

    WARDEN_ALERT_CATEGORY_TEMPLATE = "warden_alert_category_{0}"
    WARDEN_FUNCTIONALITY_TEMPLATE = "warden_functionality_{0}"

    # MARTY
    MARTY_DOWNTIME = "auto_downtime"
    MARTY_GEO = "a_geo_{0}"


def build_juggler_check(alert, child_tag, tags=None, **kwargs):
    # select juggler channel
    alert.notification_channels.add(multialert_juggler_channel.id)

    # default children for MultiAlert
    children = [
        Child(
            host=f"host={alert.project_id} & service={alert.id}_* & tag={child_tag}",
            service="all",
            instance="all",
            group_type="EVENTS"
        )
    ]

    children = kwargs.get("children", children)
    kwargs.pop("children", None)

    # default notifications for MultiAlert
    notifications = [
        NotificationOptions(
            template_name='on_status_change',
            template_kwargs=dict(
                status=['CRIT'],
                method='telegram',
                repeat=300,
                login=['l7-alerts']
            )
        )
    ]

    notifications = kwargs.get("notifications", notifications)
    kwargs.pop("notifications", None)

    # default aggregator and aggregator_kwargs
    aggregator = kwargs.get("aggregator", "logic_or")
    kwargs.pop("aggregator", None)
    aggregator_kwargs = kwargs.get("aggregator_kwargs", {"nodata_mode": "skip"})
    kwargs.pop("aggregator_kwargs", None)

    return Check(
        namespace=alert.project_id,
        host=alert.project_id,
        service=f"{alert.id}_{child_tag}",
        tags=tags,
        children=children,
        notifications=notifications,
        aggregator=aggregator,
        aggregator_kwargs=aggregator_kwargs,
        **kwargs
    )
