from balancer.production.l7_alerts.solomon.registry.project.projects import l7_balancer_project
from library.python.monitoring.solo.objects.solomon.v2 import Channel, Method, Telegram, Juggler
from library.python.monitoring.solo.util.text import prepare_text

l7_alerts_channel = Channel(
    id="l7-alerts",
    project_id=l7_balancer_project.id,
    name="l7-alerts",
    method=Method(
        telegram=Telegram(
            group_title="l7-alerts",
            text_template="Solomon alert: {{alert.id}} status: {{status.code}} labels: {{labels}} {{graphLink}}",
            send_screenshot=False
        )),
    notify_about_statuses={"ALARM"},
)

multialert_juggler_channel = Channel(
    id="multialert_juggler_channel",
    project_id=l7_balancer_project.id,
    name="multialert juggler channel",
    method=Method(
        juggler=Juggler(
            host=l7_balancer_project.id,
            service="{{alert.parent.id}}_{{alert.id}}",
            tags=["{{annotations.jugglerTags}}"],
            description=prepare_text("""
                Alert: {{{alert.name}}}
                URL: {{{url}}}
                {{#annotationsList}}
                {{{key}}}: {{{value}}}
                {{/annotationsList}}
            """)
        )
    )
)

# чтобы быть добавленными в общий regisry, все объекты, которые мы хотим создать/модифицировать должны быть указаны в списке exports
exports = [
    multialert_juggler_channel
]
