#!/usr/bin/env python3
# Этот файл только для тестирования, содержимое файлов
# L7_alerts.json
# L7_self.jinja
# L7_sd_test_alerts.json
# L7_sd_test.jinja
# 1 раз в час автоматически выгружается через API srvambry, подробности в https://wiki.yandex-team.ru/devops/instruments-for-devops/updatemartypanels/
# автоапдейт происходит через https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/devops/UpdateMartyPanels/__init__.py

import requests

server = "https://yasm.yandex-team.ru/srvambry/"

if __name__ == "__main__":
    print("L7_alerts.json...")
    alerts = open("L7_alerts.json").read()
    result = requests.post(server + "alerts/replace", headers={"Content-Type": "application/json"}, data=alerts)
    print(result.status_code, result.text)

    print("L7_self.jinja...")
    L7_self = open("L7_self.jinja").read()
    result = requests.post(server + "tmpl/panels/update/content?key=L7_self", headers={"Content-Type": "application/json"}, data=L7_self)
    print(result.status_code, result.text)

    print("L7_sd_test.json...")
    alerts = open("L7_sd_test_alerts.json").read()
    result = requests.post(server + "alerts/replace", headers={"Content-Type": "application/json"}, data=alerts)
    print(result.status_code, result.text)

    print("L7_sd_test.jinja...")
    L7_self = open("L7_sd_test.jinja").read()
    result = requests.post(server + "tmpl/panels/update/content?key=L7_sd_test", headers={"Content-Type": "application/json"}, data=L7_self)
    print(result.status_code, result.text)
