def active_health_check(host, user, url="/any_url", code=404):

    return {
        "juggler_host_name": host,
        "juggler_service_name": "health_check",
        "module": {
            "http": {
                "fail_logic": "any",
                "headers": [],
                "ok_codes": [
                    code,
                ],
                "path": url,
                "timeout": 4,
                "warn_codes": []
            },
            "type": "http"
        },
        "notifications": [
            {
                "on_desc_change": {
                    "method": [
                        "email"
                    ],
                    "status": [
                        "CRIT"
                    ]
                },
                "on_status_change": {
                    "method": [
                        "email",
                        "telegram"
                    ],
                    "status": [
                        "CRIT"
                    ],
                    "status_changes": [],
                    "users": {
                        "groups": [],
                        "logins": [
                            user,
                        ]
                    }
                },
                "type": "on_status_change"
            }
        ],
        "options": {
            "args": [],
            "env_vars": []
        }
    }

