def passive_check_enddate_certificate(host, user):
    return {
        "juggler_host_name": host,
        "juggler_service_name": "check_enddate_certificate",
        "notifications": [
            {
                "on_desc_change": {
                    "method": [
                        "email"
                    ],
                    "status": [
                        "CRIT"
                    ]
                },
                "on_status_change": {
                    "method": [
                        "email",
                        "telegram"
                    ],
                    "status": [
                        "CRIT"
                    ],
                    "status_changes": [],
                    "users": {
                        "groups": [],
                        "logins": [
                            user,
                        ]
                    }
                },
                "type": "on_status_change"
            }
        ],
        "options": {
            "args": [],
            "env_vars": []
        }
    }


def passive_push_client(host, user, args=["-l", "40000000000"]):
    return {
        "juggler_host_name": host,
        "juggler_service_name": "push-client",
        "notifications": [
            {
                "on_desc_change": {
                    "method": [
                        "email"
                    ],
                    "status": [
                        "CRIT"
                    ]
                },
                "on_status_change": {
                    "method": [
                        "telegram"
                    ],
                    "status": [
                        "CRIT"
                    ],
                    "status_changes": [],
                    "users": {
                        "groups": [],
                        "logins": [
                            user,
                        ]
                    }
                },
                "type": "on_status_change"
            }
        ],
        "options": {
            "args": args,
            "env_vars": []
        }
    }




def passive_check_space(host, user):
    return {
        "juggler_host_name": host,
        "juggler_service_name": "check_space",
        "notifications": [
            {
                "on_desc_change": {
                    "method": [
                        "email"
                    ],
                    "status": [
                        "CRIT"
                    ]
                },
                "on_status_change": {
                    "method": [
                        "telegram"
                    ],
                    "status": [
                        "CRIT"
                    ],
                    "status_changes": [],
                    "users": {
                        "groups": [],
                        "logins": [
                            user,
                        ]
                    }
                },
                "type": "on_status_change"
            }
        ],
        "options": {
            "args": [],
            "env_vars": []
        }
    }



def passive_check_tun(host, user):
    return {
        "juggler_host_name": host,
        "juggler_service_name": "check_tun",
        "notifications": [
            {
                "on_desc_change": {
                    "method": [
                        "email"
                    ],
                    "status": [
                        "CRIT"
                    ]
                },
                "on_status_change": {
                    "method": [
                        "telegram"
                    ],
                    "status": [
                        "CRIT"
                    ],
                    "status_changes": [],
                    "users": {
                        "groups": [],
                        "logins": [
                            user
                        ]
                    }
                },
                "type": "on_status_change"
            }
        ],
        "options": {
            "args": [],
            "env_vars": []
        }
    }

