#!/usr/bin/env python
#
# Provides: check_dns
#
# simple dns checker

import socket

RESOLVE_FILE = "/etc/resolv.conf"
DNS_PORT = 53

DNS_QUERY = "\xde\xad\x01\x20\x00\x01\x00\x00\x00\x00\x00\x01" \
    "\x02\x73\x33\x06\x79\x61\x6e\x64\x65\x78\x03\x6e\x65\x74\x00\x00" \
    "\x1c\x00\x01\x00\x00\x29\x10\x00\x00\x00\x00\x00\x00\x00"


def main():
    check_failed = False
    description = []

    ns_list = []
    with open(RESOLVE_FILE) as fd:
        for line in fd:
            if line.startswith("nameserver"):
                ns_list.append(line.split(' ')[1].strip())

    for dns in ns_list:
        if ":" not in dns:
            continue

        try:
            sock = socket.socket(socket.AF_INET6, socket.SOCK_DGRAM)
            sock.sendto(DNS_QUERY, (dns, DNS_PORT))
        except:
            check_failed = True
            description.append("Failed to send request to {0}".format(dns))
            continue

        data = "\x00\x00"
        try:
            sock.settimeout(10)
            data, addr = sock.recvfrom(4096)
        except:
            check_failed = True
            description.append("Failed to recv request to {0}".format(dns))
            continue

        if data[:2] != "\xde\xad":
            check_failed = True
            description.append("Incorrect ID")
            continue

        reply_code = (ord(data[4]) & 0b1111)
        if reply_code != 0:
            check_failed = True
            description.append("Incorrect reply code {0} for {1}".format(reply_code, dns))
            continue

        break

    if check_failed:
        print "PASSIVE-CHECK:check_dns;2;problems: {0}".format(" :: ".join(description))
    else:
        print "PASSIVE-CHECK:check_dns;0;ok"

if __name__ == '__main__':
    main()
