#include <balancer/modules/redirects/redirects.h>

#include <util/generic/strbuf.h>
#include <util/generic/string.h>
#include <util/stream/input.h>
#include <util/stream/output.h>
#include <util/string/split.h>
#include <util/string/strip.h>
#include <util/string/subst.h>

int main(int, const char**) {
    // others TAB src TAB dst TAB comment TAB...
    TString line;
    Cout << "ANY_REDIRECTS = [\n";
    while (Cin.ReadLine(line)) {
        TStringBuf lineIter = StripString(TStringBuf(line));
        if (!line) {
            continue;
        }
        TString tag(StripString(lineIter.NextTok('\t')));
        TString src(StripString(lineIter.NextTok('\t')));
        TString dst(StripString(lineIter.NextTok('\t')));
        TString comment(StripString(lineIter.NextTok('\t')));
        Y_ENSURE(tag && src && dst);
        Y_ENSURE(dst.find('\'') == TStringBuf::npos);

        Cout << "    {'src': '" << src << "', 'dst': '" << dst << "'},";
        if (comment) {
            Cout << "  # " << SubstGlobalCopy(TString(comment), "\n", " ");
        }
        Cout << "\n";
    }
    Cout << "]" << Endl;
}
