#!/bin/bash
set -euo pipefail

sky_selector=${1?"Usage: $0 sky_selector fnd_selector tag_selector"}
fnd_selector=${2?"Usage: $0 sky_selector fnd_selector tag_selector"}
tag_selector=${3?"Usage: $0 sky_selector fnd_selector tag_selector"}

sky run -N "
set -euo pipefail;
hst=\$(hostname);
cd $HOME && rm -rf ./\$hst && mkdir ./\$hst
found=0
for f in \$(find /coredumps/ $fnd_selector -type f); do
    res=\$(nice strings -d -n ${#tag_selector} -f \$f | nice fgrep -m 1 $tag_selector | wc -l || true)
    if [ \"\$res\" -gt 0 ]; then
        ln -s \$f ./\$hst
        found=1
    fi
done
if [ \$found == 1 ]; then
    sky share ./\$hst
fi
" $sky_selector
