#!/usr/bin/env python3

import sys
import json


def fix(node):
    if isinstance(node, dict):
        node.pop('searchapp4ios', None)
        for x in node.values():
            fix(x)
    if isinstance(node, list):
        for x in node:
            fix(x)


for fname in sys.argv[1:]:
    with open(fname) as f:
        j = json.load(f)
    fix(j)
    with open(fname, 'w') as f:
        json.dump(j, f, sort_keys=True, indent=2)

