#!/bin/sh

set -e

rm -rf diffs
mkdir diffs

svn_root=$(svn info | awk '/Working Copy Root Path/ { print $5 }')
jsondiff() {
    python "$svn_root/sandbox/projects/websearch/begemot/tasks/BegemotCreateResponsesDiff/jsondiff.py" $@
}

for old_conf in old/*; do
    conf_name=${old_conf#old/}
    jsondiff $old_conf new/$conf_name >"diffs/${conf_name%%.cfg.json}.diff" && echo "ok: $conf_name" || echo "fail: $conf_name" &
done

wait

