#!/bin/sh

set -e

svn_root=$(svn info | awk '/Working Copy Root Path/ { print $5 }')
simplify() {
    python "$svn_root/gencfg/custom_generators/balancer_gencfg/kdiff/simplify.py" $@
}

log_with_prefix() {
    while read a; do
        echo "$1 $a"
    done
}

for conf in old/* new/*; do
    (cat "$conf" | simplify 2>&1 >"${conf%%.cfg.json}.simplified" && echo "ok" || echo "fail") | log_with_prefix "$conf" &
done

wait

