#!/usr/bin/env python3

import sys
import json


def fix_h100(node):
    if isinstance(node, dict):
        h100 = node.pop('h100', None)
        if h100 is not None:
            if len(h100) != 1:
                raise Exception()
            node.update(h100)
        for x in node.values():
            fix_h100(x)
    if isinstance(node, list):
        for x in node:
            fix_h100(x)


for fname in sys.argv[1:]:
    with open(fname) as f:
        j = json.load(f)
    fix_h100(j)
    with open(fname, 'w') as f:
        json.dump(j, f, sort_keys=True, indent=2)

